header {* Context-free languages as inductive predicates *}

theory Parentheses
imports Main
begin

subsection {* Two grammars *}

text {* The alphabet: *}

datatype alphabet = A | B
type_synonym word = "alphabet list"


text {* Standard grammar: *}

inductive S :: "word \<Rightarrow> bool"
where
  S1: "S []"
| S2: "S w \<Longrightarrow> S ([A] @ w @ [B])"
| S3: "S v \<Longrightarrow> S w \<Longrightarrow> S (v @ w)"


text {* Nonstandard grammar: *}

inductive T :: "word \<Rightarrow> bool"
where
  T1: "T []"
| T23: "T v \<Longrightarrow> T w \<Longrightarrow> T (v @ ([A] @ w @ [B]))"


subsection {* Equivalence proof *}

lemma T2:
  assumes "T w"
  shows "T ([A] @ w @ [B])"
proof -
  have "T []" by (rule T1)
  from this and `T w` have "T ([] @ ([A] @ w @ [B]))"
    by (rule T23)
  then show ?thesis by simp
qed

lemma T3:
  assumes "T u" and "T v"
  shows "T (u @ v)"
  using `T v`
proof induct
  case T1
  from `T u` show "T (u @ [])" by simp
next
  case (T23 v w)
  from `T (u @ v)` and `T w` have "T ((u @ v) @ ([A] @ w @ [B]))"
    by (rule T.T23)
  then show "T (u @ (v @ [A] @ w @ [B]))" by simp
qed

theorem "S w \<longleftrightarrow> T w"
proof
  assume "S w"
  then show "T w"
  proof induct
    case S1
    show "T []" by (rule T1)
  next
    case (S2 w)
    from `T w` show "T ([A] @ w @ [B])"
      by (rule T2)
  next
    case (S3 v w)
    from `T v` and `T w` show "T (v @ w)"
      by (rule T3)
  qed
next
  assume "T w"
  then show "S w"
  proof induct
    case T1
    show "S []" by (rule S1)
  next
    case (T23 v w)
    from `S w` have "S ([A] @ w @ [B])" by (rule S2)
    with `S v` show "S (v @ ([A] @ w @ [B]))" by (rule S3)
  qed
qed

end
