header {* Isar as formal notepad *}

theory Notepad
imports Main
begin

text {*
  An Isar proof body serves as mathematical notepad to compose logical
  content, consisting of facts, terms, types.
*}


section {* Facts *}

text {*
  A fact is a simultaneous list of theorems.
*}


subsection {* Producing facts *}

notepad
begin

  txt {* via assumption ("lambda") *}
  assume a: A

  txt {* via proof ("let") *}
  have b: B sorry

  txt {* via abbreviation ("let") *}
  note c = a b

end


subsection {* Referencing facts *}

notepad
begin
  txt {* via explicit name *}
  assume a: A
  note a

  txt {* via implicit name *}
  assume A
  note this

  txt {* via literal proposition (unification with results from the proof text) *}
  assume A
  note `A`

  assume "\<And>x. B x"
  note `B a`
  note `B b`
end


subsection {* Manipulating facts *}

notepad
begin
  txt {* instantiation *}
  assume a: "\<And>x. B x"
  note a
  note a [of b]
  note a [where x = b]

  txt {* backchaining *}
  assume 1: A
  assume 2: "A \<Longrightarrow> C"
  note 2 [OF 1]
  note 1 [THEN 2]

  txt {* symmetric results *}
  assume "x = y"
  note this [symmetric]

  assume "x \<noteq> y"
  note this [symmetric]

  txt {* adhoc-simplication (take care!) *}
  assume "P ([] @ xs)"
  note this [simplified]
end


subsection {* Projections *}

text {*
  Isar facts consist of multiple theorems.  There is notation to project
  interval ranges.
*}

notepad
begin
  assume stuff: A B C D
  note stuff(1)
  note stuff(2-3)
  note stuff(2-)
end


section {* Block structure *}

text {*
  The formal notepad is block structured.  The fact produced by the last
  entry of a block is exported into the outer context.
*}

notepad
begin
  {
    have a: A sorry
    have b: B sorry
    note a b
  }
  note this
  note `A`
  note `B`
end


subsection {* Naming conventions *}

text {*
  \<bullet> Lower-case identifiers are usually preferred.

  \<bullet> Facts can be named after the main term within the proposition.

  \<bullet> Natural numbers can be used as "meaningless" names.

  \<bullet> Symbolic identifiers are supported (e.g. * ** ***).
*}


section {* Terms and Types *}

notepad
begin
  txt {* locally fixed entities *}
  fix x   -- {* local constant, without any type information yet *}
  fix x :: 'a  -- {* variant with explicit type-constraint for subsequent use*}

  fix a b
  assume "a = b"  -- {* type assignment at first occurrence in concrete term *}

  txt {* definitions (non-polymorphic) *}
  def x \<equiv> "t::'a"

  txt {* abbreviations (polymorphic) *}
  let ?f = "\<lambda>x. x"
  term "?f ?f"

  txt {* notation *}
  write x  ("***")
end

end
