header {* Calculational reasoning *}

theory Calculation
imports Main
begin

section {* Special names in Isar proofs *}

text {*
    term ?thesis
      the main conclusion of the innermost pending claim

    term "\<dots>"
    term "..."
      the argument of the last explicitly stated result
      (for infix application this is the right-hand side)

    thm this
      the last fact produced in the text
*}

notepad
begin
  have "x = y"
  proof -
    term ?thesis
    show ?thesis sorry
    term ?thesis  -- {* static! *}
  qed
  term "\<dots>"
  term "..."
  term ?this
  thm this
end

text {*
  Calculational reasoning maintains a fact "calculation" in the background.
  Certain language elements combine primary "this" with secondary "calculation".
*}


section {* Transitive chains *}

text {*
  Idea: combine "this" and "calculation" via "trans" rules.
*}

thm trans
thm less_trans
thm less_le_trans

notepad
begin
  txt {* plain bottom-up calculation *}
  have "a = b" sorry
  also
  have "b = c" sorry
  also
  have "c = d" sorry
  finally
  have "a = d" .

  txt {* variant with "\<dots>" abbreviation *}
  have "a = b" sorry
  also
  have "\<dots> = c" sorry
  also
  have "\<dots> = d" sorry
  finally
  have "a = d" .

  txt {* top-down version with explicit claim at the head *}
  have "a = d"
  proof -
    have "a = b" sorry
    also
    have "\<dots> = c" sorry
    also
    have "\<dots> = d" sorry
    finally
    show ?thesis .
  qed
next
  fix a b c d :: nat
  txt {* mixed inequalities; requires suitable base type *}

  have "a < b" sorry
  also
  have "b \<le> c" sorry
  also
  have "c = d" sorry
  finally
  have "a < d" .
end

print_trans_rules -- {* rules declared in the library *}

text {*
  Notes:

  \<bullet> The notion of "trans" rule is very general due to the flexibility
    of Pure rule composition.

  \<bullet> User applications may declare there own rules, with some care
    about the operational details of higher-order unification.
*}


subsection {* Exercise *}

text {*
  \<triangleright> Prove some elementary algebraic identies derived from group axioms.
*}

class group = times + one + inverse +
  assumes group_assoc: "(x * y) * z = x * (y * z)"
    and group_left_one: "1 * x = x"
    and group_left_inverse: "inverse x * x = 1"

lemma (in group) group_right_inverse: "x * inverse x = 1"
proof -
  txt {*
    x * inverse x = 1 * (x * inverse x)   (group_left_one)
    \<dots> = 1 * x * inverse x                (group_assoc)
    \<dots> = inverse (inverse x) * inverse x * x * inverse x"    (group_left_inverse)
    \<dots> = inverse (inverse x) * (inverse x * x) * inverse x   (group_assoc)
    \<dots> = inverse (inverse x) * 1 * inverse x     (group_left_inverse)
    \<dots> = inverse (inverse x) * (1 * inverse x)   (group_assoc)
    \<dots> = inverse (inverse x) * inverse x         (group_left_one)
    \<dots> = 1   (group_left_inverse)
  *}
  have "x * inverse x = 1 * (x * inverse x)"
    by (simp only: group_left_one)
  also have "\<dots> = 1 * x * inverse x"
    by (simp only: group_assoc)
  also have "\<dots> = inverse (inverse x) * inverse x * x * inverse x"
    by (simp only: group_left_inverse)
  also have "\<dots> = inverse (inverse x) * (inverse x * x) * inverse x"
    by (simp only: group_assoc)
  also have "\<dots> = inverse (inverse x) * 1 * inverse x"
    by (simp only: group_left_inverse)
  also have "\<dots> = inverse (inverse x) * (1 * inverse x)"
    by (simp only: group_assoc)
  also have "\<dots> = inverse (inverse x) * inverse x"
    by (simp only: group_left_one)
  also have "\<dots> = 1"
    by (simp only: group_left_inverse)
  finally show ?thesis .
qed

lemma (in group) group_right_one: "x * 1 = x"
proof -
  txt {*
    x * 1 = x * (inverse x * x)    (group_left_inverse)
    \<dots> = x * inverse x * x         (group_assoc)
    \<dots> = 1 * x                     (group_right_inverse)
    \<dots> = x                         (group_left_one)
  *}
  show ?thesis sorry
qed

lemma (in group) group_one_equality:
  assumes eq: "e * x = x"
  shows "1 = e"
proof -
  txt {*
    1 = x * inverse x          (group_right_inverse)
    \<dots> = (e * x) * inverse x   (eq)
    \<dots> = e * (x * inverse x)   (group_assoc)
    \<dots> = e * 1                 (group_right_inverse)
    \<dots> = e                     (group_right_one)
  *}
  show ?thesis sorry
qed

lemma (in group) group_inverse_equality:
  assumes eq: "x' * x = 1"
  shows "inverse x = x'"
proof -
  txt {*
    inverse x = 1 * inverse x    (group_left_one)
    \<dots> = (x' * x) * inverse x    (eq)
    \<dots> = x' * (x * inverse x)    (group_assoc)
    \<dots> = x' * 1                  (group_right_inverse)
    \<dots> = x'                      (group_right_one)
  *}
  show ?thesis sorry
qed


section {* Degenerate calculations and bigstep reasoning *}

text {*
  Idea: "this" is appended to "calculation"; no rule composition involved here.
*}

notepad
begin
  txt {* vacous proof -- typical Isar joke *}
  have A sorry
  moreover
  have B sorry
  moreover
  have C sorry
  ultimately
  have A and B and C .
next
  txt {* more content -- trivial bigstep reasoning *}
  have A sorry
  moreover
  have B sorry
  moreover
  have C sorry
  ultimately
  have "A \<and> B \<and> C" by blast
next
  txt {* more ambitous bigstep reasoning involving structured results *}
  have "A \<or> B \<or> C" sorry
  moreover
  { assume A have R sorry }
  moreover
  { assume B have R sorry }
  moreover
  { assume C have R sorry }
  ultimately
  have R by blast
end


subsection {* Exercise *}

text {*
  The Drinker's Principle says that for some person, if he is
  drunk, everybody else is drunk!

  The proof works by classical case distincton, using the rule of
  excluded-middle.

  Case 1: Everybody is drunk.  Take an arbitrary person to conclude
  the thesis.

  Case 2: Not everybody is drunk.  Then there is someone who is not
  drunk.  If that person is drunk, every body is drunk by
  contradiction.

  \<triangleright> Complete the following formal proof sketch:
*}

theorem "\<exists>a. drunk a \<longrightarrow> (\<forall>x. drunk x)"
proof -
  {
    assume "\<forall>x. drunk x"
    have ?thesis sorry
  }
  moreover
  {
    assume "\<not> (\<forall>x. drunk x)"
    have ?thesis sorry
  }
  ultimately show ?thesis sorry
qed

text {*
  \<triangleright> Do you believe the proof? Both informal and the formal version?

  \<triangleright> How robust is the proof against small changes?

  \<triangleright> What happens if some intermediate results are omitted or ignored?

  \<triangleright> What is the shortest possible proof in Isabelle/HOL?
    (Counting bytes of source text vs. complexity of formal proof object.)
*}

end

