#!/bin/bash

echo "Arrêt d'Hadoop et Spark (si démarrés)"
stop-dfs.sh >/dev/null 2>&1
stop-worker.sh >/dev/null 2>&1
stop-master.sh >/dev/null 2>&1

JPROCESS=`pidof java`
if [ "$JPROCESS" ]
then
    kill -9 $JPROCESS >/dev/null 2>&1
fi

rm -rf /tmp/hadoop*
echo "Démarrage d'hadoop"

hdfs namenode -format >/dev/null 2>&1
start-dfs.sh >/dev/null 2>&1
echo "Copie des fichiers"
hdfs dfs -mkdir -p /user
REAL_USER=`hdfs dfs -ls -d /user | head -n 1 | grep -o '[a-z0-9.]* supergroup' | cut -f 1 -d ' '`
hdfs dfs -mkdir -p /user/"$REAL_USER"/input/
hdfs dfs -put  TDD_TP_NOTE_2025_ACOMPLETER/src/resources/capitals_distances.txt  /user/$REAL_USER/input/
echo "Démarrage de spark"

start-master.sh >/dev/null 2>&1
start-worker.sh "spark://$(hostname):7077" >/dev/null 2>&1
echo "------------------------------------------------------------"
echo
echo 
echo "TP INITIALISÉ, VOUS DEVEZ UTILISER LE CHEMIN"
echo "hdfs://localhost:9000/user/$REAL_USER/input/..."
echo "dans l'exercice 3"
echo
echo
echo "------------------------------------------------------------"
