#!/bin/sh

HDFS=`which hdfs`
HADOOP=`which hadoop`
if [ -z "$HDFS" -o -z "$HADOOP" ]
then
    echo "Command hdfs ou hadoop introuvable, avez vous appelé init-tp.sh ?"
    exit 1
fi

echo  Création du .jar
jar cf /tmp/exo2.jar -C TDD_TP_NOTE_2025_ACOMPLETER/bin .

HDFS_DIR=/user/`hdfs dfs -ls -d /user | head -n 1 | grep -o '[a-z0-9.]* supergroup' | cut -f 1 -d ' '`

"$HDFS" dfs -rm -r "$HDFS_DIR"/output >/dev/null 2>&1

echo Lancement du job

"$HADOOP" jar /tmp/exo2.jar tdd.tpnote.exo2.DriverDistMinMax "$HDFS_DIR"/output "$HDFS_DIR"/input/capitals_distances.txt >/tmp/hadoop_exo2.log 2>&1

if "$HDFS" dfs -test -f "$HDFS_DIR"/output/_SUCCESS
then
	echo Job exécuté avec succès
	echo Résultat :
	"$HDFS" dfs -cat "$HDFS_DIR"/output/\*
else
	cat /tmp/hadoop_exo2.log >&2
fi
