package tdd.tpnote.exo1;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class PlaneTicketDB {

	private String host;
    private String user;
    private String base;
    private String pw;
    private String TABLE_NAME;

	public PlaneTicketDB(String host, String user, String base, String pw) throws ClassNotFoundException {

		Class.forName("org.postgresql.Driver");
		this.base = base;
		this.pw = pw;
		this.host = host;
		this.user = user;
		this.TABLE_NAME = "TICKETS_" +  " À REMPLACER ";
	}

	private Connection connect() throws SQLException {
		Connection c = DriverManager.getConnection("jdbc:postgresql://" + host + ":5432/" + base, user, pw);
		return c;
	}

	private void init()  throws IOException, SQLException {
		String file = getClass().getClassLoader().getResource("resources/plane_tickets.txt").getPath();
		BufferedReader buff = null;

		buff = new BufferedReader(new FileReader(file));

		Connection cnx = connect();
		Statement stmt = cnx.createStatement();
		System.err.println("Création de " + TABLE_NAME);
		stmt.executeUpdate("DROP TABLE IF EXISTS " + TABLE_NAME + " CASCADE");
		stmt.executeUpdate("CREATE TABLE " + TABLE_NAME + "(CITY1 VARCHAR(150), CITY2 VARCHAR(150),"
				+ "PRICE FLOAT, QTITY INTEGER)");

		PreparedStatement ps = cnx.prepareStatement("INSERT INTO " + TABLE_NAME + " VALUES(?,?,?,?)");
		String line;
		while ((line = buff.readLine()) != null) {
			String fields[] = line.split(";");
			ps.setString(1, fields[0]);
			ps.setString(2, fields[1]);
			ps.setInt(3, Integer.parseInt(fields[2]));
			ps.setInt(4, Integer.parseInt(fields[3]));
			ps.addBatch();
		}
		ps.executeBatch();
		buff.close();

	}


	public void afficheInfos(String depart) {
		try {
			System.out.println("---- INFOS POUR " + depart + " --------");
			Connection cnx = connect();
			Statement stmt = cnx.createStatement();
			ResultSet res = stmt.executeQuery("SELECT * FROM " + TABLE_NAME + " WHERE CITY1 = '" + depart + "' ORDER BY CITY2");
			while (res.next()) {
				System.out.println (
						String.format("%s, %s, %f, %d",
								res.getString("CITY1"),
								res.getString("CITY2"),
								res.getDouble("PRICE"),
								res.getInt("QTITY")
								)
						);

			}
			cnx.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/***
	 * À Compléter selon la spécification de l'énoncé
	 * @param depart : la ville de départ
	 * @throws SQLException
	 */
	public  void ajustePrixEtQtite(String depart) throws SQLException {
	  // À COMPLÉTER
	}

	/***
	 * Cette méthode appelle 5 fois de suites ajustePrixEtQtite("London").
	 * La sortie doit être identique au fichier d'exemple donné. Il n'y a rien à compléter
	 * dans cette méthode.
	 */

	public void test1() {
		try {
			afficheInfos("London");
			for(int i = 0; i < 5; i++) {
				ajustePrixEtQtite("London");
			}
			afficheInfos("London");
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/***
	 * Cette méthode doit démarrer 5 threads en parallèles qui appellent chacun
	 * ajustePrixEtQtite("London").
	 * La sortie doit être la même que celle de la méthode test1(), et donc identique au fichier
	 * donné. COMPLÉTER LA MÉTHODE À L'ENDROIT INDIQUÉ.
	 */
	public void test2()  {
		afficheInfos("London");
		Thread[] jobs = new Thread[5];
		//À COMPLÉTER :
		//Remplir le tableau avec 5 threads et les démarrer
		//Chaque thread doit lancer ajustePrixEtQtite("London")


		
		/**
		 * FIN À COMPLÉTER NE PAS MODIFIER LA SUITE.
		 */

		

		for(Thread t : jobs) {
			try {
				t.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		afficheInfos("London");
	}



	public static void main(String[] args) {

		try {
			/** Ne pas modifier */
			PlaneTicketDB db = new PlaneTicketDB("tp-postgres", "knguye10_a", "knguye10_a", "knguye10_a");
			db.init();
			/** DÉCOMMENTER L'UN OU L'AUTRE MAIS PAS LES 2 À LA FOIS. */
			db.test1();
			//db.test2();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
}
