open Ecs
open Component_defs

type t = collidable

let init _ = ()

let rec iter_pairs f s =
  match s () with
    Seq.Nil -> ()
  | Seq.Cons(e, s') ->
    Seq.iter (fun e' -> f e e') s';
    iter_pairs f s'


let update _ el =
  el
  |> iter_pairs (fun (e1:t) (e2:t) ->
      let p1 = e1#position#get in
      let b1 = e1#box#get in
      let p2 = e2#position#get in
      let b2 = e2#box#get in
      match Rect.rebound p1 b1 p2 b2 with
        Some n -> 
        e1#resolve#get n e2#tag#get;
        e2#resolve#get n e1#tag#get
      | None -> ()
    )
