open Ecs
open Component_defs
open System_defs


let draw_text ctx font score text =
  Gfx.set_color ctx Cst.font_color;
  let surface = Gfx.render_text ctx text font in
  let width, height = Gfx.surface_size surface in
  let x = Cst.window_width / 2 - width / 2 in
  let y = Cst.window_height / 2 - height / 2 in
  score#position#set Vector.{x = float x; y = float y};
  score#box#set Rect.{width;height};
  score#texture#set (Texture.Image surface)

let update_score_text ctx font score =
  let p1 = score#score1#get in
  let p2 = score#score2#get in
  let text = Format.sprintf "%d-%d" p1 p2 in
  draw_text ctx font score text

let incr_score player score =
  let r =
    if player = 1 then score#score1 else score#score2
  in
  r#set (r#get + 1)


let score ctx font =
  let e = new score () in
  update_score_text ctx font e;
  Draw_system.(register (e:>t));
  e

