open Ecs
open Component_defs
open System_defs

type tag += Paddle

let player (name, x, y, txt, width, height) =
  let e = new paddle name in
  e#texture#set txt;
  e#velocity#set Vector.zero;
  e#tag#set Paddle;
  e#position#set Vector.{x = float x; y = float y};
  e#box#set Rect.{width; height};
  e#resolve#set (fun _ t ->
      match t with
        Wall.HWall w ->
        e#velocity#set Vector.zero;
        if w#position#get.y < e#position#get.y then
          e#position#set Vector.{e#position#get with y = w#position#get.y +. float w#box#get.height}
        else
          e#position#set Vector.{e#position#get with y = w#position#get.y -. float e#box#get.height}
      | _ -> ()
    );
  Move_system.(register (e :>t));
  Draw_system.(register (e :> t));
  Collision_system.(register (e :> t));
  e

let players () =  
  player  Cst.("player1", paddle1_x, paddle1_y, paddle_color, paddle_width, paddle_height),
  player  Cst.("player2", paddle2_x, paddle2_y, paddle_color, paddle_width, paddle_height)


let player1 () = 
  let Global.{player1; _ } = Global.get () in
  player1

let player2 () =
  let Global.{player2; _ } = Global.get () in
  player2

let stop_players () =
  let Global.{player1; player2; _ } = Global.get () in
  player1 # velocity # set Vector.zero;
  player2 # velocity # set Vector.zero 

let move_player player v =
  player#velocity#set v
