(* pas demandé mais on lit dans un fichier,
   ce qui est plus commode pour tester.
*)


let read_file cin =
  let text = In_channel.input_all cin in
  Array.of_list (String.split_on_char '\n' text)

(* Cet exercice est juste là pour réviser la syntaxe
   qui peut être confusionnante :
   références, tableaux, chaînes, accès à un tableau, accès à une chaine.
*)

(* on rappelle que les boucles for n'ont pas de break en OCaml,
   on peut utiliser une exception pour sortir, ce qui est plus lisible
   que d'utiliser 2 fonctions récursives pour faire une double boucle for.
*)

let valid_coord grid r c =
  r >= 0 && c >= 0 &&
  r < Array.length grid && c < String.length grid.(r)

let has_star grid r c =
  try
    (* double boucle sur toutes les cases adjacentes,
       sauf la case elle même. *)

    for i = -1 to 1 do
      for j = -1 to 1 do
        if not (i = 0 && j = 0) then
          let ri = r + i in
          let cj = c + j in
          if valid_coord grid ri cj && grid.(ri).[cj] = '*' then
            raise Exit (* on a trouvé *)
      done;
    done;
    false (* on a fait les 2 boucles sans trouver. *)
  with Exit -> true

let count_stars grid =
  let total = ref 0 in (* un compteur des nombres trouvés *)
  (* double boucle sur toutes les cases *)
  for r = 0 to Array.length grid - 1 do
    let line = grid.(r) in
    for c = 0 to String.length line - 1 do
      let v = line.[c] in
      if v >='0' && v <= '9' && has_star grid r c then total := !total + 1
    done
  done;
  !total

let main () =
  let cin = open_in "grid.txt" in
  let grid = read_file cin in
  let count = count_stars grid in
  Printf.printf "%d\n%!" count

let () = main ()





(*

  let f =
    let cache = Hashtbl.create 16 in
    fun x -> ...

  let f =
    fun x -> ...
    let cache = Hashtbl.create 16 in



Une fois évaluée, la variable f contient une *fonction*, fun x -> ....
avant de définir la fonction, on a définit localement une table de hachage qui
est visible uniquement depuis la fonction et pas a l'extérieur.
Cette table est crée une fois pour toute lors de la définition de la fonction
et n'est pas recrée à chaque fois.

*)

let get_http_resource s =
  Unix.sleepf 3.0; (* On simule une fonction qui prend du temps. *)
  "Adresse "^s^"page <html></html>"


(* On stocke dans la table de hachage un couple (entier, resource).
   À chaque appelle on va chercher dans la table en utilisant s
   comme clé.
   S'il y est, si le compteur est inférieur à 10 on incrémente, on met
   à jour la table et on renvoie.
   Sinon remet le compteur à 1 et on redemande la ressource.
   Si la clé n'est pas présente, on renvoie une valeur de compteur qui force
   à redemander.   
*)
let get_http_resource_cache =
  let cache = Hashtbl.create 16 in
  fun s ->
    let c, doc =
      try
        Hashtbl.find cache s
      with Not_found -> 10, ""
    in
    if c < 10 then begin
      Hashtbl.replace cache s (c+1, doc);
      doc;
    end
    else
      let doc = get_http_resource s in
      Hashtbl.replace cache s (1, doc);
      doc

