(* Le type des AVL *)

module type COMPARABLE =
sig
  type t
  val compare : t -> t -> int
end

module Make (E : COMPARABLE)  =
struct

  type 'a tree =
    | Leaf
    | Node of (int * 'a tree * 'a * 'a tree)

  (* Les définitions auxiliaires ci-dessous ne sont pas à connaître.
     Elles permettent d'écrire merge ligne 67 puis de faire les questions.*)

  let height t = match t with
      Leaf -> 0
    | Node (h, _, _, _) -> h

  let node l v r = Node (1+ max (height l) (height r), l, v, r)


  let rotate_left t =
    match t with
    | Node (_, l, v, Node (_, lr, vr, rr)) -> node (node l v lr) vr rr
    | _ -> failwith "rotate_left"

  let rotate_right t =
    match t with
    | Node (_, Node (_, ll, vl, rl), v, r) -> node ll vl (node rl v r)
    | _ -> failwith "rotate_right"

  let rec join_avl_right l v r =
    match l with
    | Leaf -> failwith "impossible"
    | Node (_, ll, vl, rl) ->
      if height rl <= height r + 1 then
        let new_r = node rl v r in
        if height new_r <= height ll + 1 then node ll vl new_r
        else rotate_left (node ll vl (rotate_right new_r))
      else
        let new_r = join_avl_right rl v r in
        let new_t = node ll vl new_r in
        if height new_r <= height ll + 1 then new_t else rotate_left new_t

  let rec join_avl_left l v r =
    match r with
    | Leaf -> failwith "impossible"
    | Node (_, lr, vr, rr) ->
      if height lr <= height l + 1 then
        let new_l = node l v lr in
        if height new_l <= height rr + 1 then node new_l vr rr
        else rotate_right (node (rotate_left new_l) vr rr)
      else
        let new_l = join_avl_left l v lr in
        let new_t = node new_l vr rr in
        if height new_l <= height rr + 1 then new_t else rotate_right new_t

  let join_avl l v r =
    if height l > height r + 1 then join_avl_right l v r
    else if height r > height l + 1 then join_avl_left l v r
    else node l v r

  let rec remove_max_elt t =
    match t with
    | Leaf -> failwith "arbre vide"
    | Node (_, l, v, Leaf) -> (l, v)
    | Node (_, l, v, r) ->
      let t2, v2 = remove_max_elt r in
      (join_avl l v t2, v2)

  let rec merge l r =
    match (l, r) with
    | Leaf, _ -> r
    | _ ->
      let ll, v = remove_max_elt l in
      join_avl ll v r





  (* Réponses *)

  let singleton e = Node(1,Leaf, e, Leaf)

  let add v t = 
    let s = singleton v in 
    match t with
      Leaf -> s
    | Node (_, _, w, _) -> if E.compare v w < 0 then merge s t
      else if E.compare v w > 0 then merge t s else t

  (* Fonction vue en cours. *)
  let rec mem e t =
    match t with
      Leaf -> false
    | Node (_, l, x, r) ->
      let c = E.compare e x in
      if c < 0 then mem e l
      else if c > 0 then mem e r
      else true

  (* on parcourt le premier arbre et on ajoute dans un accmulateur les
     valeurs présentes dans le second.*)
  let inter t1 t2 =
    let rec loop t acc =
      match t with
        Leaf -> acc
      | Node (_, l, e, r) ->
        let acc1 = if mem e t2 then add e acc else acc in
        let acc2 = loop l acc1 in
        loop r acc2
    in
    loop t1 Leaf

  (* On itère par la droite pour accumuler dans la liste du plus grand au plus
     petit.*)
  let range e1 e2 t =
    let rec loop t acc =
      match t with
        Leaf -> acc
      | Node (_, l, v, r) ->
        let c2 = E.compare v e2 in
        if c2 > 0 then loop l acc (* v strictement plus grand que la borne sup,
                                     on descend uniquement à gauche.*)
        else (* on compare avecla borne inf*)
          let c1 = E.compare v e1 in
          if c1 < 0 then loop r acc (* si plus petit on se rappelle sur r *)
          else  (* sinon on est entre les bornes, on accumule et
                   on parcourt les 2 sous-arbres. *)
              let acc = loop r acc in
              let acc = v :: acc in
              loop l acc
    in
    loop t []
end



module Date =
struct
  type t = int*int*int

  let compare (a1,m1,j1) (a2,m2,j2) =
    let ca = compare a1 a2 in
    if ca <> 0 then ca else
      let cm = compare m1 m2 in
      if cm <> 0 then cm else
        compare j1 j2
end

module DateSet = Make(Date)

let creneau_reunion cal1 cal2 d1 d2 =
  let l = DateSet.range d1 d2 (DateSet.inter cal1 cal2) in
  List.iter (fun (a,m,j) -> Printf.printf "%d/%d/%d" j m a) l
