(* fonction basique.
   On a un test initial (en bas).
   - si liste vide, on termine immédiatement,
   - sinon on prend le premier élément et appelle la fonction loop.

   La fonction loop utilise l'argument n pour dire que l'élément v
   a été vu n fois. Si la liste n'est pas vide,
   - si l'élément en tête est toujours v, on incrémente
   - sinon on le place dans le résultat, et on compte maintenant
     le nombre de répétitions de w.
*)
let compress l =
  let rec loop v n l =
    match l with
      [] -> [ (v,n) ]
    | w :: ll ->
      if v = w then loop v (n+1) ll
      else (v, n) :: loop w 1 ll
  in match l with
    [] -> []
  | v :: ll -> loop v 1 ll


let () =
  assert ((compress [ 1;1;1;2;2;10;12;12;12 ]) = [1,3; 2,2; 10,1; 12,3]);
  assert ((compress [ 2;3;4 ]) = [2,1; 3,1; 4,1]);
  assert ((compress [ ]) = [ ])


let find_last_map f l =
  let rec loop last l =
    match l with
      [] -> last
    | e :: ll ->
      match f e with
        None -> loop last ll
      | Some v -> loop (Some v) ll
  in
  loop None l
(* On aurait aussi pu écrire : *)
let find_last_map2 f l =
  List.fold_left (fun last e ->
      match f e with
        None -> last
      | Some v -> Some v) None l

let f n = if n > 10 then Some (string_of_int n) else None

let () =
  assert ((find_last_map f [100; 2; 200]) = Some "200");
    assert ((find_last_map f []) = None);
  assert ((find_last_map f [1;2;3]) = None)
