(* Type représentant un trie. Version simplifiée utilisant
   uniquement des booléens.
*)

type trie =
    Node of bool * (char * trie) list

(** [empty] est le trie vide. *)


(* la fonction est juste une variante de find_trie qui
   ne « remet pas » les arbres traversés. Il est judicieux
   de regarde cette fonction avec la fonction
   find_trie du TP8 en parallèle pour voir les différences:
   - utilisation des booléens plutot qu'une option
   - non-remise en place des caractères traversés.  *)

let after_prefix t prefix =
  let rec prefix_node i t = failwith "todo"

  and prefix_list i l = failwith "todo"


(* La fonction ci-dessous est juste la pour construire un trie et tester 
   la fonction demandée.*)
let empty = Node(false, [])

let add key t =
  let rec insert_node i t =
    match t with
    | Node (o, l) ->
      if i = String.length key then Node (true, l)
      else Node (o, insert_list i l)
  and insert_list i l =
    let ci = key.[i] in
    match l with
    | [] -> [ (ci, insert_node (i + 1) empty) ]
    | (d, t) :: ll ->
      if ci > d then (d, t) :: insert_list i ll
      else if ci = d then (ci, insert_node (i + 1) t) :: ll
      else (ci, insert_node (i + 1) empty) :: l (* attention, ici l pour laisser (d,t)*)
  in
  insert_node 0 t

(* On essaye d'écrire un test un peu générique *)
let add_from_list l t =
  List.fold_left (fun acc k -> add k acc) t l

let test () =
  (* Une liste des valeurs de test *)
  let l = [ "AB"; "ABCD"; "ABCD"; "ABCEF"; "AC"; "XYZ" ] in
  (* Remplissage du dico à partir de la liste *)
  let trie =  add_from_list l empty in
  let l2 =   ["ABCEF"; "AC"; "XYZ" ] in
  let trie2 = add_from_list l2 empty in

  (* On peut utiliser l'égalité structurelle d'OCaml car 2 trie
     égaux ont la même structure en mémoire. *)
  assert (after_prefix trie "ABCE" = trie2) 

let () = test ()
