(* pas demandé mais on lit dans un fichier,
   ce qui est plus commode pour tester.
*)


let read_file cin =
  let text = In_channel.input_all cin in
  Array.of_list (String.split_on_char '\n' text)

(* Cet exercice est juste là pour réviser la syntaxe
   qui peut être confusionnante :
   références, tableaux, chaînes, accès à un tableau, accès à une chaine.
*)

(* on rappelle que les boucles for n'ont pas de break en OCaml,
   on peut utiliser une exception pour sortir, ce qui est plus lisible
   que d'utiliser 2 fonctions récursives pour faire une double boucle for.
*)

let valid_coord grid r c = failwith "todo"

let has_star grid r c = failwith "todo"

let count_stars grid = failwith "todo"

let main () =
  let cin = open_in "grid.txt" in
  let grid = read_file cin in
  let count = count_stars grid in
  Printf.printf "%d\n%!" count

let () = main ()





(*

  let f =
    let cache = Hashtbl.create 16 in
    fun x -> ...

  let f =
    fun x -> ...
    let cache = Hashtbl.create 16 in



Une fois évaluée, la variable f contient une *fonction*, fun x -> ....
avant de définir la fonction, on a définit localement une table de hachage qui
est visible uniquement depuis la fonction et pas a l'extérieur.
Cette table est crée une fois pour toute lors de la définition de la fonction
et n'est pas recrée à chaque fois.

*)

let get_http_resource s =
  Unix.sleepf 3.0; (* On simule une fonction qui prend du temps. *)
  "Adresse "^s^" : page <html></html>"


(* On stocke dans la table de hachage un couple (entier, resource).
   À chaque appelle on va chercher dans la table en utilisant s
   comme clé.
   S'il y est, si le compteur est inférieur à 10 on incrémente, on met
   à jour la table et on renvoie.
   Sinon remet le compteur à 1 et on redemande la ressource.
   Si la clé n'est pas présente, on renvoie une valeur de compteur qui force
   à redemander.   
*)
let get_http_resource_cache =
  let cache = Hashtbl.create 16 in
  fun s ->  failwith "todo"
