(* Le type des AVL *)

module type COMPARABLE =
sig
  type t
  val compare : t -> t -> int
end

module Make (E : COMPARABLE)  =
struct

  type 'a tree =
    | Leaf
    | Node of (int * 'a tree * 'a * 'a tree)

  (* Les définitions auxiliaires ci-dessous ne sont pas à connaître.
     Elles permettent d'écrire merge ligne 67 puis de faire les questions.*)

  let height t = match t with
      Leaf -> 0
    | Node (h, _, _, _) -> h

  let node l v r = Node (1+ max (height l) (height r), l, v, r)


  let rotate_left t =
    match t with
    | Node (_, l, v, Node (_, lr, vr, rr)) -> node (node l v lr) vr rr
    | _ -> failwith "rotate_left"

  let rotate_right t =
    match t with
    | Node (_, Node (_, ll, vl, rl), v, r) -> node ll vl (node rl v r)
    | _ -> failwith "rotate_right"

  let rec join_avl_right l v r =
    match l with
    | Leaf -> failwith "impossible"
    | Node (_, ll, vl, rl) ->
      if height rl <= height r + 1 then
        let new_r = node rl v r in
        if height new_r <= height ll + 1 then node ll vl new_r
        else rotate_left (node ll vl (rotate_right new_r))
      else
        let new_r = join_avl_right rl v r in
        let new_t = node ll vl new_r in
        if height new_r <= height ll + 1 then new_t else rotate_left new_t

  let rec join_avl_left l v r =
    match r with
    | Leaf -> failwith "impossible"
    | Node (_, lr, vr, rr) ->
      if height lr <= height l + 1 then
        let new_l = node l v lr in
        if height new_l <= height rr + 1 then node new_l vr rr
        else rotate_right (node (rotate_left new_l) vr rr)
      else
        let new_l = join_avl_left l v lr in
        let new_t = node new_l vr rr in
        if height new_l <= height rr + 1 then new_t else rotate_right new_t

  let join_avl l v r =
    if height l > height r + 1 then join_avl_right l v r
    else if height r > height l + 1 then join_avl_left l v r
    else node l v r

  let rec remove_max_elt t =
    match t with
    | Leaf -> failwith "arbre vide"
    | Node (_, l, v, Leaf) -> (l, v)
    | Node (_, l, v, r) ->
      let t2, v2 = remove_max_elt r in
      (join_avl l v t2, v2)

  let rec merge l r =
    match (l, r) with
    | Leaf, _ -> r
    | _ ->
      let ll, v = remove_max_elt l in
      join_avl ll v r





  (* Réponses *)

  let singleton e = failwith "todo"

  let add e t = failwith "todo"

  (* Fonction vue en cours. *)
  let rec mem e t = failwith "todo"

  (* on parcourt le premier arbre et on ajoute dans un accmulateur les
     valeurs présentes dans le second.*)
  let inter t1 t2 = failwith "todo"

  (* On itère par la droite pour accumuler dans la liste du plus grand au plus
     petit.*)
  let range e1 e2 t = failwith "todo"

end



module Date =
struct
  type t (* à compléter *)

  let compare _ _ = failwith "todo"
end

module DateSet = Make(Date)

let creneau_reunion cal1 cal2 d1 d2 = failwith "todo"
