from socket import socket
#On crée une connexion TCP en mode "serveur".
#Cette dernière se place en écoute sur l'adresse
#fictive '0.0.0.0', sur le port 4455.
# ('0.0.0.0' est une adresse spéciale
#indiquant qu'on écoute sur toutes les cartes réseau
#configurées).

adresse = ('0.0.0.0', 4455)
cnx = socket()
cnx.bind(adresse)
cnx.listen()

#Dictionnaire dont les clés sont les IPs
#et les valeurs les messages envoyés par le client.
messages_clients = {}

#Le serveur s'exécute "à l'infini" jusqu'à ce
#qu'on l'interrompe dans la console avec CTRL-C
try:
    while True:

    #La fonction accept() bloque jusqu'à ce
    #qu'un client se connecte.
    #cnx_client est une connexion vers le client
    #adr_client est un couple (ip_du_client, num port)
        cnx_client, adr_client = cnx.accept()


        #on reçoit 1000 octets du client, au plus.
        msg = cnx_client.recv(1000)

        #on ajoute le message dans le dictionnaire en utilisant
        #comme clé l'ip.
        ip_client = adr_client[0]
        if ip_client in messages_clients:
            mess_client = messages_clients[ip_client]
        else:
            mess_client = ""

        messages_clients[ip_client] = mess_client + '\n' + msg.decode()

        #on initialise une chaîne de caractères vide.
        res = ""

        #on crée une grande chaine contenant pour chaque adresse
        #le message stocké
        for a in messages_clients:
            res = res + a + ' : ' + messages_clients[a]  + '\n--\n'

        #on envoie cette chaîne au client et on se déconnecte.
        #la chaîne de caractères doit être convertie en chaîne d'octets.
        cnx_client.send(res.encode())
        cnx_client.close()

#Si on presse ctrl-C
except KeyboardInterrupt:
    cnx.close()
