from random import randint
from time import time

def tab_rand(l, a, b):
    """Renvoie un tableau de l entiers compris entre a et b inclus"""
    t = [0] * l
    for i in range(l):
        t[i] = randint(a, b)
    return t



def algo1(t):
    """Recherche naïve l'élément le plus fréquent dans un tableau t
       et renvoie cet élément et le nombre d'occurrences. Le tableau t doit être
       non-vide"""
    max_ele = None
    max_occ = -1
    for e in t:
        occ_e = 0
        for c in t:
           if c == e:
               occ_e += 1
        if occ_e > max_occ:
            max_occ = occ_e
            max_ele = e
    return (max_ele, max_occ)

def algo2(t):
    """Recherche de l'élément le plus fréquent dans un tableau t
       et renvoie cet élément et le nombre d'occurrences. Utilise un tri.
       Le tableau t doit être  non-vide"""
    t = sorted(t)
    max_ele = None
    max_occ = -1
    prev_e = None
    prev_occ = -1
    for e in t:
        if prev_e != e:
            if prev_occ > max_occ:
                max_ele = prev_e
                max_occ = prev_occ
            prev_e = e
            prev_occ = 1
        else:
            prev_occ = prev_occ + 1
    #attention pour la dernière case:
    if prev_occ > max_occ:
        max_ele = prev_e
        max_occ = prev_occ

    return (max_ele, max_occ)


def algo3(t):
    """Recherche de l'élément le plus fréquent dans un tableau t
       et renvoie cet élément et le nombre d'occurrences. Utilise un dictionnaire.
       Le tableau t doit être  non-vide"""
    max_ele = None
    max_occ = -1
    dic = {}
    for e in t:
        if e in dic:
            c = dic[e]
        else:
            c = 0
        c = c + 1
        dic[e] = c
        if c > max_occ:
            max_ele = e
            max_occ = c
    return (max_ele, max_occ)

def test():
    """Teste l'algorithme 1, 2 et 3"""
    t = [0, 1, 2, 3, 4, 4.25, 5, 6 ]
    for i in range(len(t)):
        t[i] = tab_rand(int (10 ** t[i]), 0, 100)

    for i in range(len(t)):
        test = t[i]
        if len(test) < 15000:
            # Au dela de 15000 éléments l'algo1 est beaucoup trop lent.
            t0 = time ()
            e, n = algo1(test)
            t1 = time ()
            print ("Algo 1: taille:", len(test), "resultat: (", e,",",n, ")", "temps:", (t1 - t0)*1000, "ms")
        t0 = time ()
        e, n = algo2(test)
        t1 = time ()
        print ("Algo 2: taille:", len(test), "resultat: (", e,",",n, ")", "temps:", (t1 - t0)*1000, "ms")
        t0 = time ()
        e, n = algo3(test)
        t1 = time ()
        print ("Algo 3: taille:", len(test), "resultat: (", e,",",n, ")", "temps:", (t1 - t0)*1000, "ms")
        print("---")

test()
