def conv_base10(tab):
    if len(tab) != 8:
        raise ValueError ("argument invalide")

    n = 0
    for i in range(8):
        if tab[i] != 0 and tab[i] != 1:
            raise ValueError ("argument invalide")

        n = n + tab[i] * 2**i

    return n


def conv_base2(n):
    if n > 255 or n < 0:
        raise ValueError("argument invalide")

    i = 0
    tab = [ 0 ] * 8
    while n != 0:
        tab[i] = n % 2
        i = i + 1
        n = n // 2

    return tab


def print_base2(tab):
    for i in range(len(tab)-1, -1, -1):
        print(tab[i], end="")
    print()

def add_base2(tab1, tab2):
    n1 = conv_base10(tab1)
    n2 = conv_base10(tab2)

    n = (n1 + n2) % 256

    return conv_base2(n)


def print_base2_bad(tab):

    #on inverse l'ordre des éléments du tableau tab
    for i in range(len(tab)//2):
        tmp = tab[i]
        tab[i] = tab[len(tab)-1-i]
        tab[len(tab)-1-i] = tmp

    for i in range(len(tab)):
        print(tab[i], end="")
    print()

### tests:

for i in range(256):
    for j in range (256):
        tabi = conv_base2(i)
        tabj = conv_base2(j)
        print (i, "->", tabi)
        print (j, "->", tabj)
        print ((i+j) % 256, conv_base10(add_base2(tabi, tabj)))



a = conv_base2(29)
b = conv_base2(101)
print_base2_bad(a)
print_base2_bad(b)
c = add_base2(a, b)
print("29 + 101 =", conv_base10(c))
