def bissextile(a):
    return (a % 4 == 0 and (a % 100 != 0 or a % 400))


def nbjoursannee(a):
    if bissextile(a):
        return 366
    else:
        return 365

def nbjoursmois(a, m):
    if bissextile(a) and m == 2:
        return 29
    jours = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
    return jours[m-1] #attention, les mois vont de 1 à 12, les
                      #indices de tableau de 0 à 11

def nbjoursdate(a,m,j):
    total = j
    for i in range(1, m):
        total = total+ nbjoursmois(a, i)
    return total-1


def nbjoursentre(a1, m1, j1, a2, m2, j2):
    if a2 == a1:
        return nbjoursdate(a2, m2, j2) - nbjoursdate(a1, m1, j1)

    total = 0
    # on compte le nombre d'années entières :
    for i in range(a1 + 1, a2):
        total = total + nbjoursannee(i)

    # on ajoute la dernière année incomplète :
    total = total + nbjoursdate(a2,m2,j2)

    if bissextile(a1):
        ja = 366
    else:
        ja = 365
    #On calcule le nombre de jours restant dans
    #l'année de la première date
    total = total + (ja - nbjoursdate(a1,m1,j1))
    return total
