/**
 * Operation that prints information about an element.
 */
public class Print extends Operation {

    /**
     * For an element whose kind is not statically known: print "Element"
     */
    @Override
    public void operate(Element e) {
        System.out.println("Element " + e.id + " " + e.colour);
    }

    /**
     * For an element whose kind is statically known: print the kind
     */
    public void operate(Line l) {
        System.out.println("Line " + l.id + " " + l.colour);
    }
    
    public void operate(Circle c) {
        System.out.println("Circle " + c.id + " " + c.colour);
    }
}
