# 1 "PrebuiltLexer.mll"
 

  open Lexing
  open PrebuiltParser

  let id_or_keyword =
    let h = Hashtbl.create 17 in
    List.iter (fun (s, k) -> Hashtbl.add h s k)
      [ "true",     CONST_BOOL(true);
	"false",    CONST_BOOL(false);
	"while",    WHILE;
	"if",       IF;
	"then",     THEN;
	"else",     ELSE;
	"integer",  INT;
	"boolean",  BOOL;
	"print",    PRINT;
	"main",     MAIN;
	"var",      VAR;
      ] ;
    fun s ->
      try  Hashtbl.find h s
      with Not_found -> IDENT(s)


# 28 "PrebuiltLexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\237\255\238\255\001\000\001\000\001\000\002\000\003\000\
    \245\255\246\255\247\255\004\000\249\255\250\255\084\000\018\000\
    \002\000\002\000\254\255\248\255\244\255\243\255\241\255\240\255\
    \239\255\036\000\252\255\253\255\005\000\005\000\255\255\254\255\
    ";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\017\000\017\000\013\000\017\000\017\000\
    \255\255\255\255\255\255\017\000\255\255\255\255\003\000\002\000\
    \004\000\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\002\000\255\255\255\255\
    ";
  Lexing.lex_default = 
   "\002\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\255\255\000\000\000\000\255\255\255\255\
    \255\255\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\027\000\000\000\000\000\255\255\255\255\000\000\000\000\
    ";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\017\000\017\000\017\000\017\000\017\000\000\000\017\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \017\000\006\000\017\000\000\000\000\000\000\000\004\000\023\000\
    \016\000\013\000\008\000\010\000\018\000\009\000\031\000\030\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\011\000\012\000\005\000\007\000\022\000\021\000\
    \020\000\019\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\029\000\000\000\028\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\000\
    \000\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\003\000\024\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\000\000\
    \000\000\000\000\000\000\014\000\000\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\026\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\017\000\017\000\000\000\255\255\017\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\017\000\255\255\255\255\255\255\000\000\004\000\
    \000\000\000\000\000\000\000\000\016\000\000\000\028\000\029\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\005\000\006\000\
    \007\000\011\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\025\000\255\255\025\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\014\000\000\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\255\255\
    \255\255\255\255\255\255\014\000\255\255\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\025\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec token lexbuf =
    __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 33 "PrebuiltLexer.mll"
      ( token lexbuf )
# 157 "PrebuiltLexer.ml"

  | 1 ->
# 35 "PrebuiltLexer.mll"
      ( comment lexbuf; token lexbuf )
# 162 "PrebuiltLexer.ml"

  | 2 ->
# 37 "PrebuiltLexer.mll"
      ( CONST_INT (int_of_string (lexeme lexbuf)) )
# 167 "PrebuiltLexer.ml"

  | 3 ->
# 39 "PrebuiltLexer.mll"
      ( id_or_keyword (lexeme lexbuf) )
# 172 "PrebuiltLexer.ml"

  | 4 ->
# 41 "PrebuiltLexer.mll"
      ( BEGIN )
# 177 "PrebuiltLexer.ml"

  | 5 ->
# 43 "PrebuiltLexer.mll"
      ( END )
# 182 "PrebuiltLexer.ml"

  | 6 ->
# 45 "PrebuiltLexer.mll"
      ( SEMI )
# 187 "PrebuiltLexer.ml"

  | 7 ->
# 47 "PrebuiltLexer.mll"
      ( SET )
# 192 "PrebuiltLexer.ml"

  | 8 ->
# 49 "PrebuiltLexer.mll"
      ( PLUS )
# 197 "PrebuiltLexer.ml"

  | 9 ->
# 51 "PrebuiltLexer.mll"
      ( MINUS )
# 202 "PrebuiltLexer.ml"

  | 10 ->
# 53 "PrebuiltLexer.mll"
      ( STAR )
# 207 "PrebuiltLexer.ml"

  | 11 ->
# 55 "PrebuiltLexer.mll"
      ( EQUAL )
# 212 "PrebuiltLexer.ml"

  | 12 ->
# 57 "PrebuiltLexer.mll"
      ( NEQ )
# 217 "PrebuiltLexer.ml"

  | 13 ->
# 59 "PrebuiltLexer.mll"
      ( LT )
# 222 "PrebuiltLexer.ml"

  | 14 ->
# 61 "PrebuiltLexer.mll"
      ( LE )
# 227 "PrebuiltLexer.ml"

  | 15 ->
# 63 "PrebuiltLexer.mll"
      ( AND )
# 232 "PrebuiltLexer.ml"

  | 16 ->
# 65 "PrebuiltLexer.mll"
      ( OR )
# 237 "PrebuiltLexer.ml"

  | 17 ->
# 67 "PrebuiltLexer.mll"
      ( failwith ("Unknown character : " ^ (lexeme lexbuf)) )
# 242 "PrebuiltLexer.ml"

  | 18 ->
# 69 "PrebuiltLexer.mll"
      ( EOF )
# 247 "PrebuiltLexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 25
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 73 "PrebuiltLexer.mll"
      ( comment lexbuf; comment lexbuf )
# 259 "PrebuiltLexer.ml"

  | 1 ->
# 75 "PrebuiltLexer.mll"
      ( () )
# 264 "PrebuiltLexer.ml"

  | 2 ->
# 77 "PrebuiltLexer.mll"
      ( comment lexbuf )
# 269 "PrebuiltLexer.ml"

  | 3 ->
# 79 "PrebuiltLexer.mll"
      ( failwith "Unterminated comment" )
# 274 "PrebuiltLexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

;;

